/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.preferences;

import com.aptana.editor.php.epl.PHPEplPlugin;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class PreferencesSupport {
    private HashMap projectToScope;
    private String nodeQualifier;
    private Preferences preferenceStore;

    public PreferencesSupport(String nodeQualifier, Preferences preferenceStore) {
        this.nodeQualifier = nodeQualifier;
        this.preferenceStore = preferenceStore;
        this.projectToScope = new HashMap();
    }

    public String getProjectSpecificPreferencesValue(String key, String def, IProject project) {
        IEclipsePreferences node;
        assert (project != null);
        ProjectScope scope = (ProjectScope)this.projectToScope.get(project);
        if (scope == null) {
            scope = new ProjectScope(project);
            this.projectToScope.put(project, scope);
        }
        if ((node = scope.getNode(this.nodeQualifier)) != null) {
            return node.get(key, def);
        }
        return null;
    }

    public String getPreferencesValue(String key, String def, IProject project) {
        if (project == null) {
            return this.getWorkspacePreferencesValue(key);
        }
        String projectSpecificPreferencesValue = this.getProjectSpecificPreferencesValue(key, def, project);
        if (projectSpecificPreferencesValue == null) {
            return this.getWorkspacePreferencesValue(key);
        }
        return projectSpecificPreferencesValue;
    }

    public String getWorkspacePreferencesValue(String key) {
        return this.preferenceStore == null ? null : this.preferenceStore.getString(key);
    }

    public static String getWorkspacePreferencesValue(String key, Preferences preferenceStore) {
        return preferenceStore.getString(key);
    }

    public boolean setProjectSpecificPreferencesValue(String key, String value, IProject project) {
        IEclipsePreferences node;
        assert (project != null);
        ProjectScope scope = (ProjectScope)this.projectToScope.get(project);
        if (scope == null) {
            scope = new ProjectScope(project);
            this.projectToScope.put(project, scope);
        }
        if ((node = scope.getNode(this.nodeQualifier)) != null) {
            node.put(key, value);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                PHPEplPlugin.logError(e);
            }
            return true;
        }
        return false;
    }
}

